@extends('template.template')
@section('title','Pesan')
@section('main')

<div class="main">
	<h2><strong>Tambah Blog</strong></h2>
	<hr><br>
	<div class="data-content">
		<form action="{{ route('blogstore') }}" method="post" enctype="multipart/form-data">
			@csrf
			<div class="float-start col-lg-9 col-md-8 col-12 border">
				<div class="p-2">
					<div class="form-group">
						<label><strong>Judul Blog</strong></label>
						<input type="text" name="judul_blog" class="form-control" required>
					</div>
					<hr class="m-2">
					<div class="form-group">
						<label><strong>Content</strong></label>
						<textarea style="min-height: 100vh;" id="ckeditor" class="ckeditor" required name="content"></textarea>
					</div>	
					<div class="form-group">
						<input type="submit" value="Simpan" class="form-control black mt-2">
					</div>	
				</div>
			</div>
			<div class="float-start col-lg-3 col-md-4 col-12 border">
				<div class="p-2">
					<div class="form-group">
						<label><strong>Author</strong></label>
						<input type="text" name="author" class="form-control" required>
					</div>
					<hr class="m-1">
					<div class="form-group">
						<label><strong>Tanggal Dibuat</strong></label>
						<input type="datetime-local" name="created_at" class="form-control" required>
					</div>
					<hr class="m-1">
					<div class="form-group">
						<img src="" class="w-100" id="image">
						<label><strong>Featured Image</strong></label>
						<input type="file" id="featured" name="featured" class="form-control" required>
					</div>
				</div>
			</div>
			<div class="clearfix"></div>
		</form>
	</div>
</div>
<script type="text/javascript">
	let icon = document.getElementById('featured')
	let imagefet = document.getElementById('image')

	icon.addEventListener('change', function () {
        gambar(this);
    })

    function gambar(a) {
        if (a.files && a.files[0]) {     
            var reader = new FileReader();    
            reader.onload = function (e) {
                imagefet.src=e.target.result;
            }    
            reader.readAsDataURL(a.files[0]);
        }
    }
</script>
@endsection